fun main(args: Array<String>) {
    val options = arrayOf("Kamień", "Nożyce", "Papier")
    val gameChoice = getGameChoice(options)
    val userChoice = getUserChoice(options)
    printResult(userChoice, gameChoice)
}


fun getGameChoice(optionsParam: Array<String>) =
    optionsParam[(Math.random() * optionsParam.size).toInt()]

fun getUserChoice(optionsParam: Array<String>): String {
    var isValidChoice = false
    var userChoice = ""
    // Pętla pobierania opcji - kończy się gdy opcja będzie prawidłowa.
    while (!isValidChoice) {
        // Prosimy gracza o podanie opcji.
        print("Proszę wpisać jedną z opcji:")
        for (item in optionsParam) print(" $item")
        println(".")
        // Wczytujemy tekst wpisany przez gracza.
        val userInput = readLine()
        // Weryfikujemy poprawność wpisanych danych.
        if (userInput != null && userInput in optionsParam) {
            isValidChoice = true
            userChoice = userInput
        }
        // Jeśli opcja nie jest prawidłowa, wyświetlamy komunikat.
        if (!isValidChoice) println("Musisz wpisać jedną z dostępnych opcji.")
    }
    return userChoice
}

fun printResult(userChoice: String, gameChoice: String) {
    val result: String
    // Określamy jaki będzie wynik
    if (userChoice ==  gameChoice) result = "Remis!"
    else if ((userChoice == "Kamień" && gameChoice == "Nożyce") ||
             (userChoice == "Papier" && gameChoice == "Kamień") ||
             (userChoice == "Nożyce" && gameChoice == "Papier")) result = "Wygrałeś!"
    else result = "Przegrałeś!"
    // Wyświetlamy wyniki
    println("Wybrałeś $userChoice, a ja wybrałem $gameChoice. $result")
}
